/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k.indication.client;

import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCCltAuthenticator;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCCltConnMonitor;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCCltEventQueue;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCCltSubscription;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCConnErrHandler;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCEvent;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCEventHandler;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCHandlerSubscription;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCIndicationErrLogger;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCQueueSubscription;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCSocket;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCSubscriptionMgr;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbemcmd.xml.SocketProvider;

public class HSCSubscriptionMgrImpl
extends Thread
implements HSCSubscriptionMgr {
    private static final String COMMON_BUNDLE_NAME = "HSCCommonBundle";
    private static final String ERROR_INVALID_SUB_ID = "HMCERRV3EVT000: Invalid subscription id {0}";
    private static final String ERROR_AUTHENTICATE = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ERROR_AUTHENTICATE", "HMCERRV3EVT001: Authentication failed");
    private HSCCltAuthenticator mAuthenticator = null;
    private HSCSocket mSocket;
    private boolean mAutoClose;
    private String mHostName;
    private int mPort = 9198;
    private int mRetry;
    private HSCConnErrHandler mConnErrHandler;
    private Hashtable mEvents;
    private Hashtable mSubscriptions;
    private boolean mClosed;
    private static int mNextId = 0;
    private HSCCltConnMonitor mConnMonitor = null;
    private String mLocalHostName = null;
    private boolean mReconnAfterFail = true;
    private long mLastCommTime = 0L;
    public static final int LOST_CONN_EVENT = -1;
    public static final int RECONNECT_EVENT = -2;
    public static final int DUMMY_CONN_EVENT = -3;
    public HSCIndicationErrLogger mErrLogger = null;

    public String getServerHostName() {
        return this.mHostName;
    }

    public int getServerPort() {
        return this.mPort;
    }

    public int getConnectionRetryTime() {
        return this.mRetry;
    }

    public void setConnectionRetryTime(int n) {
        this.mRetry = n;
    }

    public HSCConnErrHandler getConnErrHandler() {
        return this.mConnErrHandler;
    }

    public void setConnErrHandler(HSCConnErrHandler hSCConnErrHandler) {
        this.mConnErrHandler = hSCConnErrHandler;
    }

    public boolean isAutoClose() {
        return this.mAutoClose;
    }

    public long getLastCommTime() {
        return this.mLastCommTime;
    }

    public void setAutoClose(boolean bl) {
        this.mAutoClose = bl;
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    public int getSubscriptionNum() {
        return this.mSubscriptions.size();
    }

    private static synchronized int getNextId() {
        return mNextId++;
    }

    public HSCSubscriptionMgrImpl(String string, String string2, int n, boolean bl, int n2, HSCConnErrHandler hSCConnErrHandler, HSCIndicationErrLogger hSCIndicationErrLogger) {
        this.mHostName = string;
        this.mErrLogger = hSCIndicationErrLogger;
        if (n != -1) {
            this.mPort = n;
        }
        this.mAutoClose = bl;
        this.mRetry = n2;
        this.mConnErrHandler = hSCConnErrHandler;
        this.mEvents = new Hashtable();
        this.mSubscriptions = new Hashtable();
        this.mAuthenticator = new HSCCltAuthenticator(string, string2, this.getClientInfo(), hSCIndicationErrLogger, this.mLocalHostName);
        this.connect();
    }

    public HSCSubscriptionMgrImpl(String string, String string2, int n, boolean bl, int n2, HSCConnErrHandler hSCConnErrHandler, HSCIndicationErrLogger hSCIndicationErrLogger, String string3, boolean bl2) {
        this.mHostName = string;
        this.mLocalHostName = string3;
        this.mErrLogger = hSCIndicationErrLogger;
        if (n != -1) {
            this.mPort = n;
        }
        this.mAutoClose = bl;
        this.mRetry = n2;
        this.mConnErrHandler = hSCConnErrHandler;
        this.mReconnAfterFail = bl2;
        this.mEvents = new Hashtable();
        this.mSubscriptions = new Hashtable();
        this.mAuthenticator = new HSCCltAuthenticator(string, string2, this.getClientInfo(), hSCIndicationErrLogger, this.mLocalHostName);
        this.connect();
    }

    private String getClientInfo() {
        try {
            Exception exception = new Exception();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            String string = byteArrayOutputStream.toString();
            printStream.close();
            byteArrayOutputStream.close();
            return string;
        }
        catch (Throwable throwable) {
            this.logException(throwable);
            return null;
        }
    }

    private void connect() {
        this.mSocket = null;
        long l = System.currentTimeMillis() + (long)(this.mRetry * 60000);
        Socket socket = null;
        InetAddress inetAddress = null;
        while (this.mRetry == -1 || System.currentTimeMillis() <= l) {
            try {
                Thread.sleep(15000L);
                SocketProvider socketProvider = SocketProvider.getProvider();
                if (socketProvider != null) {
                    inetAddress = InetAddress.getByName(this.mHostName);
                    socket = socketProvider.createSocket(inetAddress, this.mPort);
                } else {
                    socket = new Socket(this.mHostName, this.mPort);
                }
                this.mSocket = new HSCSocket(socket, false);
                this.mConnMonitor = new HSCCltConnMonitor(this);
                this.mConnMonitor.startMonitoring(this.mSocket);
            }
            catch (Throwable throwable) {
                this.logException(throwable);
                if (this.mRetry == -1 || System.currentTimeMillis() < l) continue;
                this.mConnErrHandler.connectionError(this, throwable, this.mRetry);
            }
            break;
        }
    }

    public void reconnect() throws HSCException {
        Serializable serializable;
        Object k;
        this.mAuthenticator.reset();
        this.connect();
        Enumeration enumeration = this.mSubscriptions.keys();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            serializable = (HSCCltSubscription)this.mSubscriptions.get(k);
            String string = ((HSCCltSubscription)serializable).getUserName() + " %%% " + ((HSCCltSubscription)serializable).getPassword();
            String string2 = (String)hashtable.get(string);
            if (string2 == null) {
                string2 = this.mAuthenticator.authenticate(((HSCCltSubscription)serializable).getUserName(), ((HSCCltSubscription)serializable).getPassword());
                if (string2 == null) {
                    this.unsubscribe(((HSCCltSubscription)serializable).getSubId(), ((HSCCltSubscription)serializable).getUserName(), ((HSCCltSubscription)serializable).getPassword());
                    continue;
                }
                hashtable.put(string, string2);
            }
            ((HSCCltSubscription)serializable).setAuthKey(string2);
        }
        enumeration = this.mEvents.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            serializable = (Vector)this.mEvents.get(k);
            this.subscribe((HSCCltSubscription)((Vector)serializable).elementAt(0));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                if (this.mClosed) {
                    return;
                }
                Object object = null;
                try {
                    if (this.mSocket == null) continue;
                    object = this.mSocket.readObject();
                    this.mLastCommTime = System.currentTimeMillis();
                }
                catch (Throwable throwable) {
                    if (this.mClosed) continue;
                    this.mSocket = null;
                    this.mConnMonitor.close();
                    this.handleEvent(this.createLostConnEvent());
                    if (!this.mReconnAfterFail) {
                        this.mSocket = null;
                        this.close();
                        return;
                    }
                    this.reconnect();
                    this.handleEvent(this.createReconnectEvent());
                    continue;
                }
                if (object == null) continue;
                if (this.mClosed) {
                    return;
                }
                if (!(object instanceof HSCEvent)) continue;
                this.handleEvent((HSCEvent)object);
            }
        }
        catch (HSCException hSCException) {
            this.logException(hSCException);
            throw new RuntimeException(hSCException.getMessage());
        }
    }

    public void closeSocket() {
        if (this.mSocket == null) {
            return;
        }
        try {
            this.mSocket.close();
            this.interrupt();
            this.mSocket = null;
        }
        catch (Throwable throwable) {
            this.logException(throwable);
        }
    }

    private void handleEvent(HSCEvent hSCEvent) {
        String string = hSCEvent.getEventKey();
        Vector vector = (Vector)this.mEvents.get(string);
        if (vector != null && vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                HSCCltSubscription hSCCltSubscription = (HSCCltSubscription)vector.elementAt(n);
                hSCCltSubscription.handleEvent(hSCEvent, this);
                ++n;
            }
        }
    }

    public int subscribe(int n, String string, String string2, String string3, HSCEventHandler hSCEventHandler) throws HSCException {
        String string4 = this.authenticate(string2, string3);
        if (string4 == null) {
            return -1;
        }
        HSCHandlerSubscription hSCHandlerSubscription = new HSCHandlerSubscription(n, string, true, string2, string3, hSCEventHandler);
        hSCHandlerSubscription.setAuthKey(string4);
        this.subscribe(hSCHandlerSubscription);
        return hSCHandlerSubscription.getSubId();
    }

    public int subscribe(int n, String string, String string2, String string3, HSCCltEventQueue hSCCltEventQueue) throws HSCException {
        String string4 = this.authenticate(string2, string3);
        if (string4 == null) {
            return -1;
        }
        HSCQueueSubscription hSCQueueSubscription = new HSCQueueSubscription(n, string, true, string2, string3, hSCCltEventQueue);
        hSCQueueSubscription.setAuthKey(string4);
        this.subscribe(hSCQueueSubscription);
        return hSCQueueSubscription.getSubId();
    }

    protected String authenticate(String string, String string2) throws HSCException {
        if (this.mClosed) {
            return null;
        }
        String string3 = this.needAuthenticate(string, string2);
        if (string3 == null && (string3 = this.mAuthenticator.authenticate(string, string2)) == null) {
            return null;
        }
        return string3;
    }

    private boolean subscribe(HSCCltSubscription hSCCltSubscription) throws HSCException {
        if (hSCCltSubscription.getSubId() == -1) {
            hSCCltSubscription.setSubId(HSCSubscriptionMgrImpl.getNextId());
            Integer n = new Integer(hSCCltSubscription.getSubId());
            this.mSubscriptions.put(n, hSCCltSubscription);
            String string = hSCCltSubscription.getEventKey();
            Vector<HSCCltSubscription> vector = (Vector<HSCCltSubscription>)this.mEvents.get(string);
            if (vector == null) {
                vector = new Vector<HSCCltSubscription>();
                this.mEvents.put(string, vector);
            }
            vector.addElement(hSCCltSubscription);
            if (vector.size() > 1) {
                return true;
            }
        }
        try {
            if (hSCCltSubscription.getEventType() != -1 && hSCCltSubscription.getEventType() != -2) {
                this.mSocket.writeObject(hSCCltSubscription.getServerSub());
                this.mLastCommTime = System.currentTimeMillis();
            }
        }
        catch (Exception exception) {
            this.reconnect();
        }
        return true;
    }

    public void unsubscribe(int n, String string, String string2) throws HSCException {
        if (this.mClosed) {
            return;
        }
        Integer n2 = new Integer(n);
        HSCCltSubscription hSCCltSubscription = (HSCCltSubscription)this.mSubscriptions.get(n2);
        if (hSCCltSubscription == null) {
            throw new HSCException(HSCResourceBundleUtil.getMessage(COMMON_BUNDLE_NAME, "ERROR_INVALID_SUB_ID", ERROR_INVALID_SUB_ID, new String[]{"" + n}));
        }
        if (!string.equals(hSCCltSubscription.getUserName()) || !string2.equals(hSCCltSubscription.getPassword())) {
            throw new HSCException(ERROR_AUTHENTICATE);
        }
        this.mSubscriptions.remove(n2);
        String string3 = hSCCltSubscription.getEventKey();
        Vector vector = (Vector)this.mEvents.get(string3);
        vector.removeElement(hSCCltSubscription);
        if (vector.size() == 0) {
            this.mEvents.remove(string3);
            hSCCltSubscription.setSubscription(false);
            try {
                if (hSCCltSubscription.getEventType() != -1 && hSCCltSubscription.getEventType() != -2) {
                    this.mSocket.writeObject(hSCCltSubscription.getServerSub());
                    this.mLastCommTime = System.currentTimeMillis();
                }
            }
            catch (IOException iOException) {
                this.logException(iOException);
            }
        }
        if (this.mEvents.size() == 0 && this.mAutoClose) {
            this.close();
        }
    }

    public void unsubscribe(int n, String string, HSCEventHandler hSCEventHandler, String string2, String string3) throws HSCException {
        if (this.mClosed) {
            return;
        }
        Enumeration enumeration = this.mSubscriptions.keys();
        while (enumeration.hasMoreElements()) {
            HSCHandlerSubscription hSCHandlerSubscription;
            Object k = enumeration.nextElement();
            Object v = this.mSubscriptions.get(k);
            if (!(v instanceof HSCHandlerSubscription) || (hSCHandlerSubscription = (HSCHandlerSubscription)v).getEventType() != n || hSCHandlerSubscription.getObjectType() != null && !hSCHandlerSubscription.getObjectType().equals(string) || hSCHandlerSubscription.getHandler() != hSCEventHandler) continue;
            this.unsubscribe((Integer)k, string2, string3);
        }
    }

    public void unsubscribe(int n, String string, HSCCltEventQueue hSCCltEventQueue, String string2, String string3) throws HSCException {
        if (this.mClosed) {
            return;
        }
        Enumeration enumeration = this.mSubscriptions.keys();
        while (enumeration.hasMoreElements()) {
            HSCQueueSubscription hSCQueueSubscription;
            Object k = enumeration.nextElement();
            Object v = this.mSubscriptions.get(k);
            if (!(v instanceof HSCQueueSubscription) || (hSCQueueSubscription = (HSCQueueSubscription)v).getEventType() != n || hSCQueueSubscription.getObjectType() != null && !hSCQueueSubscription.getObjectType().equals(string) || hSCQueueSubscription.getQueue() != hSCCltEventQueue) continue;
            this.unsubscribe((Integer)k, string2, string3);
        }
    }

    public void close() throws HSCException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.mEvents = null;
        this.mSubscriptions = null;
        this.mAuthenticator = null;
        try {
            if (this.mSocket != null) {
                this.mSocket.close();
                this.mSocket = null;
            }
        }
        catch (Exception exception) {
            this.logException(exception);
            throw new HSCException("Close subscription failed", exception);
        }
        try {
            if (this.mConnMonitor != null) {
                this.mConnMonitor.close();
            }
        }
        catch (Exception exception) {
            this.logException(exception);
            throw new HSCException("Close connection monitor failed", exception);
        }
    }

    private String needAuthenticate(String string, String string2) {
        Enumeration enumeration = this.mSubscriptions.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            HSCCltSubscription hSCCltSubscription = (HSCCltSubscription)this.mSubscriptions.get(k);
            if (!hSCCltSubscription.getUserName().equals(string) || !hSCCltSubscription.getPassword().equals(string2)) continue;
            return hSCCltSubscription.getAuthKey();
        }
        return null;
    }

    public HSCEvent createLostConnEvent() {
        return new HSCEvent(-1, null, null, null, System.currentTimeMillis());
    }

    public HSCEvent createReconnectEvent() {
        return new HSCEvent(-2, null, null, null, System.currentTimeMillis());
    }

    public void logException(Throwable throwable) {
        if (this.mErrLogger != null) {
            this.mErrLogger.logException(throwable);
        }
    }
}

